#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################



$mysql{user}	= "%mysqluser%";
$mysql{pass}	= '%mysqlpass%';
$mysql{host}	= "%mysqlhost%";
$mysql{port}	= "%mysqlport%";
$mysql{db}	= "%mysqldb%";

$cf{tmppath}	= "%tmppath%";
$cf{dirperms}	= %dirperms%;

$cf{datapath} = "%datapath%";

unless ($cf{datapath} and $cf{datapath} ne "\%datapath\%") {
	$cf{datapath} = "";
	($cf{datapath} = $ENV{SCRIPT_FILENAME} || "") =~ s/\/[^\s\/]+$//g
		if $ENV{SCRIPT_FILENAME};
	$cf{datapath} ||= $ENV{PWD} || join ("", `pwd`); chomp $cf{datapath};
	die("Could not locate datapath, please specify in routines.pl")
		if (!$cf{datapath});
}



#----------------------! do not edit below this line !-----------------------


# Modules
umask 0;
use strict;
foreach ("DBD::mysql") {
	(my $path = $_) =~ s/::/\//g;
	eval { require "$path.pm" };
	if (!$@) {
		import $_;
	} else {
		err("Could not find module $_! Install this [as root] by doing \"perl -MCPAN -e 'install $_'\" in telnet");
	}
}

use Socket;
use vars qw(%mysql $db);

$db = sqlcon();
err("Cannot write to temp dir, please modify routines.pl")
	if !-w $cf{tmppath};
my $ac = dosql(qq[select name from ap_cats]);
while (my $cat = ($ac->fetchrow_array)[0]) {
	push(@cats, $cat);
}

#----------------------------------! subs !----------------------------------


sub	sqlcon {
	return DBI->connect("DBI:mysql:database=$mysql{db};host=$mysql{host};port=$mysql{port}",
		$mysql{user}, $mysql{pass}, { PrintError => 0 })
		|| err("Could not connect to MySQL server; check that it is running (with 'ps auxw | grep mysqld'), and that your user/password info is correct in routines.pl");
}

sub 	urienc {
	my $uri = $_[0] or return;
	my %escapes;
	for (0..255) {
		$escapes{chr($_)} = sprintf("%%%02X", $_);
	}
	$uri =~ s/([\x00-\x20\"#%;<>?{}|\\^~`\[\]\x7F-\xFF])/$escapes{$1}/g;
	return $uri;
}

sub	mkdir_r {
	# recursive mkdir routine
	my ($dir, $perms) = @_;
	$perms ||= $cf{dirperms};
	mderr() if !$dir;
	return 1 if -d $dir;
	(my $parent = $dir) =~ s/\/?[^\/]+$//;
	if (-d $parent) {
		mkdir($dir, $perms) or mderr();
	} else {
		mkdir_r($parent, $perms);
		mkdir($dir, $perms) or mderr();
	}
	return 1;
	
	sub	mderr {
		err("Could not make directory $dir. Check permissions and ownership are correct.");
	}
}



sub	readfile {
	open (F, "< $_[0]") || err("Could not open file $_[0]");
	my $dat = join("", <F>);
	close F;
	
	return $dat;
}

sub	readrandtmpl {
	my $dir = shift;
	my $quiet = shift;
	my $tmpl = randfile($dir, "\.(tmpl|s?html?)")
		or return;
	(my $ldirs = $dir) =~ s/.*\/(\w+\/\w+)/$1/;
	v("   - Using template $ldirs/$tmpl\n") unless $quiet;
	return (readfile("$dir/$tmpl"), "$dir/$tmpl");
}

sub	randfile {
        # random file selector; stays quiet, errors should be checked on
        # return:
        #       $x = randfile("/dir")   || err("doh")
	my ($dir, $ext, $type) = (shift, shift, shift);

	opendir (F, "$dir") or return undef;
	my @files = grep { /$ext$/ && !/^\./ && -f "$dir/$_" } readdir(F);
	if (defined $type) {
		foreach (@{$used{$type}}) {
			@files = grep { !/^\Q$_\E$/ } @files;
		}
	}
	closedir F;
	return $files[rand(@files)] || undef;
}


sub	randline {
	my ($table, $query, $field) = @_;
	my $ac = dosql(qq[select count(*) from ap_$table].
		($query ? " $query" : undef));
	my $n = int(rand(($ac->fetchrow_array)[0]));
	my $max = $n || 1;
	$ac = dosql(qq[select * from ap_$table].
		($query ? " $query" : undef).
		qq[ limit $n,$max]);
	return ($ac->rows ? ($field ? ${$ac->fetchrow_hashref}{$field}: $ac->fetchrow_hashref) : undef);
}

sub	readconf {
	my $ac = dosql(qq[select * from ap_data]);
	my $row = $ac->fetchrow_hashref;
	foreach (keys %{$row}) {
		$cf{$_} = $$row{$_};
	}
	$cf{version} = sprintf("1.%03d", $cf{lastupdateid});
}

sub	dosql {
	my ($query) = shift;
	my $ac = $db->prepare($query);
	$ac->execute
		|| err("A MySQL error occurred! [$query] (".$ac->errstr.")");
	return $ac;
}

sub	get {
	my $data = shift;
	$data =~ s/^.+:\/\///;
	$data =~ /^([a-z0-9.-]+)(\/.+?)?(\?(.+?))$/i;
	my ($host, $file, $params) = ($1, $2, $4);
	return gethttp({
		host	=> "$host",
		file	=> "$file",
		params	=> "$params",		
	});
}

sub	gethttp {
	# proprietary http get routine
	# gethttp({
	#	host		=> "www.some.com",
	#	port		=> 80,
	#	file		=> "/cgi-bin/test-cgi",
	#	method		=> "GET",
	#	params		=> "foo=bar&buzz=ding",
	#	ua		=> "Mozilla/4.0",
	#	referer		=> "http://some.com",
	#	timeout		=> 30,
	#	auth		=> "login:pass",
	#	pat		=> qr/id='([0-9]+)'/i,
	#	max		=> (0|1),
	#	cookie		=> "somecookie=value",
	# })
	my %data = %{$_[0]};
	my $out;	
	$data{host}	=~ s/^.+:\/\///;
	$data{port} 	||= 80;
	$data{file} 	||= "/";
	$data{method} 	||= "GET";
	$data{ua}	||= "n/a";
	$data{timeout} 	||= 30;
	
	socket(S, AF_INET, SOCK_STREAM, getprotobyname("tcp"))
		or return;
	my $ip = (gethostbyname($data{host}))[4]
		or return;
	my $pack = pack('Sna4x8', AF_INET, $data{port}, $ip);
	if (connect(S, $pack)) {
		select (S);
		$| = 1;
		eval {
			local $SIG{ALRM} = sub { die "Connection to $data{host} timed out" };
			alarm ($data{timeout});
			$data{params} = urienc($data{params});
			
			if ($data{method} =~ /post/i) {
				my $clength = length($data{params});
				print S	"POST $data{file} HTTP/1.0\n".
					"Host: $data{host}\n".
					"User-Agent: $data{ua}\n".
					($data{referer} ? "Referer: $data{referer}\n" : "").
					($data{cookie} ? "Cookie: $data{cookie}\n" : "").
					($data{auth} ? "Authorization: Basic " . b64enc($data{auth}) . "\n" : "").
					"Content-length: $clength\n".
					"Content-type: application/x-www-form-urlencoded\n".
					"\n$data{params}\n";
			}
			else {
				# get
				$data{file} .= "?$data{params}" if $data{params};
				print S "GET $data{file} HTTP/1.0\n".
					"Host: $data{host}\n".
					"User-Agent: $data{ua}\n".
					($data{referer} ? "Referer: $data{referer}\n" : "").
					($data{cookie} ? "Cookie: $data{cookie}\n" : "").
					($data{auth} ? "Authorization: Basic " . b64enc($data{auth}) . "\n" : "").
					"\n";
			}
			while (<S>) {
#				tr/\r//d;
				if ($data{pat}) {
					if (/$data{pat}/) {
						if ($data{max}) {
							$out = $1 if ($1 > $out) || !$out;
						} else {
							$out = $1;
							last;
						}
					}
				} else {
					$out .= $_;
				}
			}
		};
		alarm 0;
		select STDOUT;
#		return if $@;
		return $out =~ /\n\s*\n/ ? (wantarray ?
			((split(/\n\s*\n/, $out, 2))[1,0]) :
			(split(/\n\s*\n/, $out, 2))[1]) : $out;
	} else {
		wrn("Could not connect to $data{host}");
	}
}

sub	b64enc {
	my $in = shift;
	chop (my $out = pack("u", $in));
	($out = substr($out, 1)) =~ tr| -_`|A-Za-z0-9+/A|;
	my $padding = (3 - length($in) % 3) % 3;
	$out =~ s/.{$padding}$/'=' x $padding/e if $padding;
	return $out;
}

1;
